% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{aws_file_copy}
\alias{aws_file_copy}
\title{Copy files between buckets}
\usage{
aws_file_copy(remote_path, bucket, force = FALSE, ...)
}
\arguments{
\item{remote_path}{(character) one or more remote S3 paths. required}

\item{bucket}{(character) bucket to copy files to. required.
if the bucket does not exist we prompt you asking if you'd like
the bucket to be created}

\item{force}{(logical) force bucket creation without going through
the prompt. default: \code{FALSE}. Should only be set to \code{TRUE} when
required for non-interactive use.}

\item{...}{named parameters passed on to \code{s3fs::s3_file_copy()}}
}
\value{
vector of paths, length matches \code{length(remote_path)}
}
\description{
Copy files between buckets
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucket1 <- random_bucket()
aws_bucket_create(bucket1)

# create files in an existing bucket
tfiles <- replicate(n = 3, tempfile())
for (i in tfiles) cat("Hello\nWorld\n", file = i)
paths <- s3_path(bucket1, c("aaa", "bbb", "ccc"), ext = "txt")
aws_file_upload(tfiles, paths)

# create a new bucket
bucket2 <- random_bucket()
new_bucket <- aws_bucket_create(bucket = bucket2)

# add existing files to the new bucket
aws_file_copy(paths, bucket2)

# or, create a bucket that doesn't exist yet
bucket3 <- random_bucket()
aws_file_copy(paths, bucket3, force = TRUE)

# Cleanup
six_bucket_delete(bucket1, force = TRUE)
six_bucket_delete(bucket2, force = TRUE)
six_bucket_delete(bucket3, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other files: 
\code{\link{aws_file_attr}()},
\code{\link{aws_file_delete}()},
\code{\link{aws_file_download}()},
\code{\link{aws_file_exists}()},
\code{\link{aws_file_rename}()},
\code{\link{aws_file_upload}()},
\code{\link{six_file_upload}()}
}
\concept{files}
