% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database-redshift.R
\name{aws_db_redshift_con}
\alias{aws_db_redshift_con}
\title{Get a database connection to Amazon Redshift}
\usage{
aws_db_redshift_con(
  user,
  pwd,
  id = NULL,
  host = NULL,
  port = NULL,
  dbname = NULL,
  ...
)
}
\arguments{
\item{user, pwd, host, port, dbname, ...}{named parameters passed on to
\href{https://dbi.r-dbi.org/reference/dbConnect.html}{DBI::dbConnect}. Note that
the \code{user} and \code{pwd} are for your AWS IAM account; and the same as
those you used to create the cluster with \code{\link[=aws_db_redshift_create]{aws_db_redshift_create()}}}

\item{id}{(character) Cluster identifier. If you supply \code{id}, we'll fetch
\code{host}, \code{port}, and \code{dbname}. If \code{id} is not supplied. you have to supply
\code{host}, \code{port}, and \code{dbname}. Refer to this parameter definition in
\code{\link[=aws_db_redshift_create]{aws_db_redshift_create()}} for more details.}
}
\value{
an object of class \code{RedshiftConnection}
}
\description{
Get a database connection to Amazon Redshift
}
\details{
The connection returned is created using
\href{https://rpostgres.r-dbi.org/}{RPostgres}

You can manage Redshift programatically via
\href{https://www.paws-r-sdk.com/docs/redshift/}{paws::redshift}
}
\examples{
\dontrun{
library(DBI)
library(RPostgres)

con_rshift <- aws_db_redshift_con("<define all params here>")
con_rshift
library(RPostgres)
dbListTables(con_rshift)
dbWriteTable(con_rshift, "mtcars", mtcars)
dbListTables(con_rshift)

library(dplyr)
tbl(con_rshift, "mtcars")
}
}
\seealso{
Other database: 
\code{\link{aws_db_cluster_status}()},
\code{\link{aws_db_instance_status}()},
\code{\link{aws_db_rds_con}()},
\code{\link{aws_db_rds_create}()},
\code{\link{aws_db_rds_list}()},
\code{\link{aws_db_redshift_create}()}
}
\concept{database}
