% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket.R
\name{aws_bucket_tree}
\alias{aws_bucket_tree}
\title{Print a tree of the objects in a bucket}
\usage{
aws_bucket_tree(bucket, recurse = TRUE, ...)
}
\arguments{
\item{bucket}{(character) bucket name; must be length 1. required}

\item{recurse}{(logical) returns all AWS S3 objects in lower sub
directories, default: \code{TRUE}}

\item{...}{Additional arguments passed to \code{s3fs::s3_dir_tree()}}
}
\value{
character vector of objects/files within the bucket,
printed as a tree
}
\description{
Print a tree of the objects in a bucket
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucket_name <- random_bucket()
if (!aws_bucket_exists(bucket_name)) aws_bucket_create(bucket_name)
links_file <- file.path(system.file(), "Meta/links.rds")
pkgs_file <- file.path(system.file(), "Meta/package.rds")
demo_file <- file.path(system.file(), "Meta/demo.rds")
aws_file_upload(
  c(links_file, pkgs_file, demo_file),
  s3_path(
    bucket_name,
    c(
      basename(links_file),
      basename(pkgs_file),
      basename(demo_file)
    )
  )
)
aws_bucket_tree(bucket_name)

# cleanup
objs <- aws_bucket_list_objects(bucket_name)
aws_file_delete(objs$uri)
aws_bucket_delete(bucket_name, force = TRUE)
aws_bucket_exists(bucket_name)
\dontshow{\}) # examplesIf}
}
\seealso{
Other buckets: 
\code{\link{aws_bucket_create}()},
\code{\link{aws_bucket_delete}()},
\code{\link{aws_bucket_download}()},
\code{\link{aws_bucket_exists}()},
\code{\link{aws_bucket_list_objects}()},
\code{\link{aws_bucket_upload}()},
\code{\link{aws_buckets}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_bucket_upload}()}
}
\concept{buckets}
