% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket.R
\name{aws_bucket_create}
\alias{aws_bucket_create}
\title{Create an S3 bucket}
\usage{
aws_bucket_create(bucket, ...)
}
\arguments{
\item{bucket}{(character) bucket name. required}

\item{...}{named parameters passed on to
\href{https://www.paws-r-sdk.com/docs/s3_create_bucket/}{create_bucket}}
}
\value{
the bucket path (character)
}
\description{
Create an S3 bucket
}
\note{
Requires the env var \code{AWS_REGION}
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucket2 <- random_bucket()
aws_bucket_create(bucket2)

# cleanup
six_bucket_delete(bucket2, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other buckets: 
\code{\link{aws_bucket_delete}()},
\code{\link{aws_bucket_download}()},
\code{\link{aws_bucket_exists}()},
\code{\link{aws_bucket_list_objects}()},
\code{\link{aws_bucket_tree}()},
\code{\link{aws_bucket_upload}()},
\code{\link{aws_buckets}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_bucket_upload}()}
}
\concept{buckets}
