% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billing.R
\name{aws_billing_raw}
\alias{aws_billing_raw}
\title{Fetch billing data - rawest form}
\usage{
aws_billing_raw(
  date_start,
  metrics,
  granularity = "daily",
  filter = NULL,
  group_by = NULL,
  date_end = as.character(Sys.Date())
)
}
\arguments{
\item{date_start, date_end}{Start and end date to get billing data for.
Date format expected: \code{yyyy-MM-dd}. required}

\item{metrics}{(character) which metrics to return. required. One of:
AmortizedCost, BlendedCost, NetAmortizedCost, NetUnblendedCost,
NormalizedUsageAmount, UnblendedCost, and UsageQuantity}

\item{granularity}{(character) monthly, daily, hourly. required.}

\item{filter}{(list) filters costs by different dimensions. optional.}

\item{group_by}{(list) group costs using up to two different groups,
either dimensions, tag keys, cost categories, or any two group by types.
optional.}
}
\value{
list with slots for:
\itemize{
\item NextPageToken
\item GroupDefinitions
\item ResultsByTime
\item DimensionValueAttributes
}
}
\description{
Fetch billing data - rawest form
}
\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(lubridate)
aws_billing_raw(date_start = today() - days(3), metrics = "BlendedCost")
\dontshow{\}) # examplesIf}
}
\seealso{
Other billing: 
\code{\link{aws_billing}()}
}
\concept{billing}
