% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Basic_functions.R
\name{standard}
\alias{standard}
\title{Standardization with double centered and column scaling}
\usage{
standard(data, dif.tol = 0.001, max.iter = 10)
}
\arguments{
\item{data}{input matrix with n x px.}

\item{dif.tol}{the value for the threshold of scaling}

\item{max.iter}{default value = 10}
}
\value{
standardized matrix with n x px.
}
\description{
Standardization with double centered and column scaling
}
\examples{
\donttest{
spmwm = 3*matrix(rnorm(100000),nrow=100)+1
dim(spmwm)
apply(spmwm,1,mean) # we want these to be 0
apply(spmwm,2,mean) # we want these to be 0
apply(spmwm,2,sd) # we want each of these variances to be 1

spmwm_cp=standard(spmwm)
max(abs(apply(spmwm_cp,1,mean)))
max(abs(apply(spmwm_cp,2,mean)))
max(abs(apply(spmwm_cp,2,sd)-1))

}
}
