% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_pwexp.R
\name{fit_pwexp}
\alias{fit_pwexp}
\title{Piecewise exponential survival estimation}
\usage{
fit_pwexp(
  srv = Surv(time = ex1_delayed_effect$month, event = ex1_delayed_effect$evntd),
  intervals = array(3, 3)
)
}
\arguments{
\item{srv}{Input survival object (see \code{\link[survival:Surv]{survival::Surv()}});
note that only 0 = censored, 1 = event for \code{\link[survival:Surv]{survival::Surv()}}.}

\item{intervals}{Vector containing positive values indicating
interval lengths where the exponential rates are assumed.
Note that a final infinite interval is added if any events occur
after the final interval specified.}
}
\value{
A matrix with rows containing interval length, estimated rate,
-2 * log-likelihood for each interval.
}
\description{
Computes survival function, density function, -2 * log-likelihood based
on input dataset and intervals for piecewise constant failure rates.
Initial version assumes observations are right censored or events only.
}
\examples{
# Use default arguments for delayed effect example dataset (ex1_delayed_effect)
library(survival)

# Example 1
rateall <- fit_pwexp()
rateall

# Example 2
# Estimate by treatment effect
rate1 <- with(subset(ex1_delayed_effect, trt == 1), fit_pwexp(Surv(month, evntd)))
rate0 <- with(subset(ex1_delayed_effect, trt == 0), fit_pwexp(Surv(month, evntd)))

rate1
rate0
rate1$rate / rate0$rate

# Chi-square test for (any) treatment effect (8 - 4 parameters = 4 df)
pchisq(sum(rateall$m2ll) - sum(rate1$m2ll + rate0$m2ll),
  df = 4,
  lower.tail = FALSE
)

# Compare with logrank
survdiff(formula = Surv(month, evntd) ~ trt, data = ex1_delayed_effect)

# Example 3
# Simple model with 3 rates same for each for 3 months,
# different for each treatment after months
rate1a <- with(subset(ex1_delayed_effect, trt == 1), fit_pwexp(Surv(month, evntd), 3))
rate0a <- with(subset(ex1_delayed_effect, trt == 0), fit_pwexp(Surv(month, evntd), 3))
rate1a$rate / rate0a$rate

m2ll0 <- rateall$m2ll[1] + rate1a$m2ll[2] + rate0a$m2ll[2]
m2ll1 <- sum(rate0$m2ll) + sum(rate1$m2ll)

# As a measure of strength, chi-square examines improvement in likelihood
pchisq(m2ll0 - m2ll1, df = 5, lower.tail = FALSE)
}
