% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simtimer.R
\name{as.sim_datetime}
\alias{as.sim_datetime}
\title{Transformation from a datetime to a sim_datetime}
\usage{
as.sim_datetime(datetime, origin_date)
}
\arguments{
\item{datetime}{A datetime (POSIXt)}

\item{origin_date}{A datetime (POSIXt)}
}
\value{
A sim_datetime
}
\description{
as.sim_datetime() transforms a regular datetime element (POSIXt) to a sim_datetime
(integer representing the passed seconds since origin_date).
The timezone (tz) will be ignored at the moment.
Therefore tz of datetime and origin_date should be identical.
}
\examples{
origin_date <- as.POSIXct("2016-01-01 00:00:00", tz = "UTC")
as.sim_datetime(as.POSIXct("2016-01-01 00:01:00", tz = "UTC"), origin_date)
# [1] 60
as.sim_datetime(as.POSIXct("2016-01-02 00:01:00", tz = "UTC"), origin_date)
# [1] 86460
}
