% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleCache.R
\name{simpleCache}
\alias{simpleCache}
\title{Create a new cache or load a previously created cache.}
\usage{
simpleCache(
  cacheName,
  instruction = NULL,
  buildEnvir = NULL,
  reload = FALSE,
  recreate = FALSE,
  noload = FALSE,
  cacheDir = getCacheDir(),
  cacheSubDir = NULL,
  timer = FALSE,
  buildDir = getOption("RBUILD.DIR"),
  assignToVariable = NULL,
  loadEnvir = parent.frame(),
  searchEnvir = getOption("SIMPLECACHE.ENV"),
  nofail = FALSE,
  batchRegistry = NULL,
  batchResources = NULL,
  pepSettings = NULL,
  ignoreLock = FALSE,
  lifespan = NULL
)
}
\arguments{
\item{cacheName}{A character vector for a unique name for the cache. Be careful.}

\item{instruction}{R expression (in braces) to be evaluated. The returned value of this
code is what will be cached under the cacheName.}

\item{buildEnvir}{An environment (or list) providing additional variables
necessary for evaluating the code in instruction.}

\item{reload}{Logical indicating whether to force re-loading the cache,
even if it exists in the env.}

\item{recreate}{Logical indicating whether to force reconstruction of the
cache}

\item{noload}{Logical indicating whether to create but not load the cache.
noload is useful for: you want to create the caches, but not load (like a
cache creation loop).}

\item{cacheDir}{Character vector specifying the directory where caches are
saved (and loaded from). Defaults to the variable set by
\code{\link[=setCacheDir]{setCacheDir()}}.}

\item{cacheSubDir}{Character vector specifying a subdirectory within the
\code{cacheDir} variable. Defaults to \code{NULL}.}

\item{timer}{Logical indicating whether to report how long it took to create
the cache.}

\item{buildDir}{Location of Build files (files with instructions for use If
the instructions argument is not provided). Defaults to RBUILD.DIR
global option.}

\item{assignToVariable}{Character vector for a variable name to load the
cache into. By default, \code{simpleCache} assigns the cache to a
variable named \code{cacheName}; you can overrule that here.}

\item{loadEnvir}{An environment. Into which environment would you like to
load the variable? Defaults to \code{\link[base]{parent.frame}}.}

\item{searchEnvir}{a vector of environments to search for the already loaded
cache.}

\item{nofail}{By default, simpleCache throws an error if the instructions
fail. Use this option to convert this error into a warning. No cache will
be created, but simpleCache will not then hard-stop your processing. This
is useful, for example, if you are creating a bunch of caches (for
example using \code{lapply}) and it's ok if some of them do not complete.}

\item{batchRegistry}{A \code{batchtools} registry object (built with
 \code{\link[batchtools]{makeRegistry}}). If provided, this cache will be created on
the cluster using your batchtools configuration}

\item{batchResources}{A list of variables to provide to batchtools for
cluster resource managers. Used as the \code{res} argument to
\code{\link[batchtools]{batchMap}}}

\item{pepSettings}{Experimental untested feature.}

\item{ignoreLock}{Internal parameter used for batch job submission; don't
touch.}

\item{lifespan}{Numeric specifying the maximum age of cache, in days, to
allow before automatically triggering \code{recreate=TRUE}.}
}
\description{
Given a unique name for an  R object, and instructions for how to make that
object, use the simpleCache function to create and cache or load the object.
This should be used for computations that take a long time and generate a
table or something used repeatedly (in other scripts, for example). Because
the cache is tied to the object name, there is some danger of causing
troubles if you misuse the caching system. The object should be considered
static.
}
\details{
You should pass a bracketed R code snippet like \code{rnorm(500)} as the
instruction, and simpleCache will create the object. Alternatively, if the
code to create the cache is large, you can put an R script called object.R in
the \code{\link[=setCacheBuildDir]{RBUILD.DIR}} (the name of the file *must* match the name of the object it
creates *exactly*). If you don't provide an instruction, the function sources
RBUILD.DIR/object.R and caches the result as the object. This source file
*must* create an object with the same name of the object. If you already have
an object with the name of the object to load in your current environment,
this function will not try to reload the object; instead, it returns the
local object. In essence, it assumes that this is a static object, which you
will not change. You can force it to load the cached version instead with
"reload".

Because R uses lexical scope and not dynamic scope, you may need to pass some
environment variables you use in your instruction code. You can use this
using the parameter buildEnvir (just provide a list of named variables).
}
\examples{
# choose location to store caches
cacheDir = tempdir()
cacheDir
setCacheDir(cacheDir)

# build some caches
simpleCache("normSample", { rnorm(5e3, 0,1) }, recreate=TRUE, timer=TRUE)
simpleCache("normSample", { rnorm(5e3, 0,1) })
simpleCache("normSample", { rnorm(5e3, 0,1) }, reload=TRUE)

# storing a cache after-the-fact
normSample2 = rnorm(10, 0, 1)
storeCache("normSample2")

# what's available?
listCaches()

# load a cache
simpleCache("normSample")

# load multiples caches
loadCaches(c("normSample", "normSample2"), reload=TRUE)
}
