% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_parallel.R
\name{do_parallel}
\alias{do_parallel}
\title{Perform Parallel Tasks}
\usage{
do_parallel(.trj, ..., .env, wait = TRUE, mon_all = FALSE)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{...}{sub-trajectories or list of sub-trajectories to parallelise.}

\item{.env}{the simulation environment.}

\item{wait}{if \code{TRUE}, the arrival waits until all parallel sub-trajectories
are finished; if \code{FALSE}, the arrival continues as soon as the first
parallel task ends.}

\item{mon_all}{if \code{TRUE}, \code{get_mon_arrivals} will show one
line per clone.}
}
\value{
Returns the following chain of activities: \code{\link[simmer]{clone}}
> \code{\link[simmer:clone]{synchronize}} (> \code{\link[simmer:send]{wait}}
> \code{\link[simmer:send]{untrap}} if \code{wait=FALSE}) (see examples below).
}
\description{
This brick encapsulates the activity of \code{n} workers running parallel
sub-trajectories.
}
\examples{
env <- simmer()
signal <- function() get_name(env)

task.1 <- trajectory("task 1") \%>\%
  timeout(function() rexp(1))
task.2 <- trajectory("task 2") \%>\%
  timeout(function() rexp(1))

## These are equivalent:
trajectory() \%>\%
  do_parallel(
    task.1,
    task.2,
    .env = env, wait = TRUE
  )

trajectory() \%>\%
  clone(
    n = 3,
    trajectory("original") \%>\%
      trap(signal) \%>\%
      wait() \%>\%
      wait() \%>\%
      untrap(signal),
    task.1[] \%>\%
      send(signal),
    task.2[] \%>\%
      send(signal)) \%>\%
  synchronize(wait = TRUE)

## These are equivalent:
trajectory() \%>\%
  do_parallel(
    task.1,
    task.2,
    .env = env, wait = FALSE
  )

trajectory() \%>\%
  clone(
    n = 3,
    trajectory("original") \%>\%
      trap(signal),
    task.1[] \%>\%
      send(signal),
    task.2[] \%>\%
      send(signal)) \%>\%
  synchronize(wait = FALSE) \%>\%
  wait() \%>\%
  untrap(signal)

}
