% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_SDE}
\alias{sim_SDE}
\title{Simulate 1-3D Markovian Stochastic Differential Equations}
\usage{
sim_SDE(
  N = 1000,
  M = 1,
  x0,
  t0 = 0,
  T = 1,
  Dt = rlang::missing_arg(),
  drift,
  diffusion,
  corr = NULL,
  alpha = 0.5,
  mu = 0.5,
  type = "ito",
  method = "euler",
  keep_full = TRUE
)
}
\arguments{
\item{N}{The number of time steps.}

\item{M}{The number of simulations.}

\item{x0}{The initial values of the SDE. The number of values determine the dimension of the SDE.}

\item{t0}{initial time.}

\item{T}{terminal time.}

\item{Dt}{time step. If missing, default will be (T - t0) / N.}

\item{drift}{An expression of the drift function. The number of expressions determine the dimension of the SDE. Should be the function of \code{t}, \code{x}, \code{y} and \code{z} (\code{y} and \code{z} are only included for 2D or 3D cases).}

\item{diffusion}{An expression of the diffusion function. The number of expressions determine the dimension of the SDE. Should be the function of \code{t}, \code{x}, \code{y} and \code{z} (\code{y} and \code{z} are only included for 2D or 3D cases).}

\item{corr}{The correlations between the Brownian motions. Only used for 2D or 3D cases. Must be a real symmetric positive-definite matrix of size 2x2 or 3x3. If NULL, the default is the identity matrix.}

\item{alpha, mu}{weight of the predictor-corrector scheme; the default \code{alpha = 0.5} and \code{mu = 0.5}.}

\item{type}{if \code{type="ito"} simulation sde of Itô type, else \code{type="str"} simulation sde of Stratonovich type; the default \code{type="ito"}.}

\item{method}{numerical methods of simulation, the default \code{method = "euler"}.}

\item{keep_full}{Whether to keep the full snssde1d/snssde2d/snssde3d object. If TRUE, the full object will be returned. If FALSE, only the simulated values will be returned as a matrix or a list of matrices (when \code{M >= 2}).}
}
\value{
Depending on the value of \code{keep_full}, the output will be a list of \code{snssde1d}, \code{snssde2d} or \code{snssde3d} objects, or a matrix or a list of matrices of the simulated values.
}
\description{
A wrapper to the simulation utilities provided by the \pkg{Sim.DiffProc} package. You may skip this step and write your own simulation function for more customized simulation.
}
\examples{
# From the Sim.DiffProc package

set.seed(1234, kind = "L'Ecuyer-CMRG")
mu <- 4
sigma <- 0.1
fx <- expression(y, (mu * (1 - x^2) * y - x))
gx <- expression(0, 2 * sigma)
mod2d <- sim_SDE(drift = fx, diffusion = gx, N = 1000,
Dt = 0.01, x0 = c(0, 0), type = "str", method = "rk1",
M = 2, keep_full = FALSE)

print(as.mcmc.list(mod2d))
}
