% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{simstudy.t2}
\alias{simstudy.t2}
\title{simstudy.t2}
\usage{
simstudy.t2(
  nx,
  ny,
  meanx = 0,
  meany = 1,
  sdx = 1,
  sdy = 1,
  num.experiments = 1,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  var.equal = FALSE,
  conf.level = 0.95,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  experiment.name = "experiment",
  group.name = "group",
  x.value = "x",
  y.value = "y",
  value.name = "value",
  seed = 3471,
  vstr = 3.6
)
}
\arguments{
\item{nx}{A numeric value for the number of observations in the x group for each experiment.}

\item{ny}{A numeric value for the number of observations in the y group for each experiment.}

\item{meanx}{A numeric value for the expected value of the x group used in the simulation.}

\item{meany}{A numeric value for the expected value of the y group used in the simulation.}

\item{sdx}{A numeric value for the standard deviation of the x group used in the simulation.}

\item{sdy}{A numeric value for the standard deviation of the y group used in the simulation.}

\item{num.experiments}{A numeric value representing the number of simulated experiments.}

\item{alternative}{See help(t.test).}

\item{mu}{See help(t.test)}

\item{var.equal}{A logical indicating whether to treat the two variances as being equal. If TRUE, then a pooled variance is used to estimate the variance, otherwise the variances are estimated separately. See help(t.test).}

\item{conf.level}{See help(t.test)}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{group.name}{A character value providing the name of the column of the group labels.}

\item{x.value}{A character value specifying the label used for data in the x group (in the column labled by the group.name parameter).}

\item{y.value}{A character value specifying the label used for data in the y group (in the column labled by the group.name parameter).}

\item{value.name}{A character value specifying the name of the column that contains the value of the simulated data.}

\item{seed}{A single numeric value, interpreted as an integer, or NULL.   See help(set.seed).}

\item{vstr}{A character string containing a version number, e.g., "1.6.2". The default RNG configuration of the current R version is used if vstr is greater than the current version.  See help(set.seed).}
}
\value{
A list containing the following components:

\itemize{
  \item{\code{simdat.t2}}{A data frame of the simulated t-distributed data for two groups.}
  \item{\code{test.statistics.t2}}{A data frame containing the results of the t-tests for two groups.}
  \item{\code{sim.analysis.t2}}{A data frame containing the analysis of the simulated study for t-tests for two groups.}
}
}
\description{
simstudy.t2
}
\examples{
study.t2 <- simstudy.t2(nx = 30, ny = 40,
meanx = 0, meany = 0.2, sdx = 1, sdy = 1, num.experiments = 2,
 alternative = "less", mu = 0, conf.level = 0.9,
 the.quantiles = c(0.1, 0.5, 0.9), experiment.name = "experiment_id",
  group.name = "category", x.value = "a",
  y.value = "b", value.name = "measurement", seed = 41)
}
