% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{simstudy.chisq.test.ind}
\alias{simstudy.chisq.test.ind}
\title{simstudy.chisq.test.ind}
\usage{
simstudy.chisq.test.ind(
  n,
  values,
  probs,
  num.experiments = 1,
  conf.level = 0.95,
  correct = TRUE,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  experiment.name = "experiment",
  group.name = "group",
  group.values = NULL,
  value.name = "value",
  seed = 403,
  vstr = 3.6
)
}
\arguments{
\item{n}{A vector of sample sizes for the different groups.}

\item{values}{A vector of values specifying the sample space.}

\item{probs}{A matrix of probabilities used to simulate the values in each group.  The rows of the probs matrix correspond to the groups, while the columns correspond to the values.}

\item{num.experiments}{A numeric value representing the number of simulated experiments.}

\item{conf.level}{A numeric value between 0 and 1 representing the confidence level (1 - significance level).}

\item{correct}{See help(chisq.test).}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{group.name}{A character value providing the name of the column of the group labels.}

\item{group.values}{A vector of unique values that identify the different groups, e.g. c("x", "y", "z").  If NULL, then values "x1", "x2", ..., "xk" will be assigned for the k groups specified.}

\item{value.name}{A character value providing the name for the simulated values.}

\item{seed}{A single numeric value, interpreted as an integer, or NULL.   See help(set.seed).}

\item{vstr}{A character string containing a version number, e.g., "1.6.2". The default RNG configuration of the current R version is used if vstr is greater than the current version.  See help(set.seed).}
}
\value{
A list containing three elements:
  simdat.chisq.ind : A data frame of the simulated data based on chi-squared distributions for independent groups.
  test.statistics.chisq.test.ind: A data frame containing the results of chi-squared tests for independence performed on the simulated data.
  sim.analysis: Summary statistics or analysis results from the chi-squared tests for independence.
}
\description{
simstudy.chisq.test.ind
}
\examples{
n <- c(50, 75, 100)
values <- LETTERS[1:4]
group.names <- paste0("group_", 1:3)
probs <- matrix(data = c(0.25, 0.25, 0.25, 0.25, 0.4, 0.3,
0.2, 0.1, 0.2, 0.4, 0.2, 0.2),
nrow = length(n), byrow = TRUE)

study.chisq.ind <- simstudy.chisq.test.ind(n = c(30, 35, 40),
 values = LETTERS[1:4], probs = probs, num.experiments = 2,
  conf.level = 0.95, correct = TRUE, the.quantiles = c(0.025, 0.975),
   experiment.name = "exp_id", group.name = "treatment_group",
   group.values = paste0("group_", 1:3), value.name = "category",
   seed = 77)

}
