% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{sim.t}
\alias{sim.t}
\title{sim.t}
\usage{
sim.t(
  n,
  mean = 0,
  sd = 1,
  num.experiments = 1,
  experiment.name = "experiment",
  value.name = "x",
  seed = 7261,
  vstr = 3.6
)
}
\arguments{
\item{n}{A numeric value for the number of observations in each experiment.}

\item{mean}{A numeric value for the expected value of the data to be simulated.}

\item{sd}{A numeric value for the standard deviation of the data to be simulated.}

\item{num.experiments}{A numeric value representing the number of simulated experiments.}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{value.name}{A character value providing the name for the simulated values.}

\item{seed}{A single numeric value, interpreted as an integer, or NULL.   See help(set.seed).}

\item{vstr}{A character string containing a version number, e.g., "1.6.2". The default RNG configuration of the current R version is used if vstr is greater than the current version.  See help(set.seed).}
}
\value{
A data frame with simulated data for a t-test.
        The returned table will have columns corresponding to 'experiment.name'
        and 'value.name'.
}
\description{
sim.t
}
\examples{
simdat.t <- sim.t(n = 25, mean = 0.3, sd = 1,  num.experiments = 2,
experiment.name = "experiment", value.name = "x", seed = 2187)

}
