% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{sim.chisq.test.ind}
\alias{sim.chisq.test.ind}
\title{sim.chisq.test.ind}
\usage{
sim.chisq.test.ind(
  simdat.chisq.ind,
  correct = TRUE,
  experiment.name = "experiment",
  group.name = "variable",
  value.name = "value"
)
}
\arguments{
\item{simdat.chisq.ind}{Data for use in chi squared tests of independence across one or more experiments.  Structure is in the form returned by the function simitation::sim.chisq.ind().}

\item{correct}{See help(chisq.test).}

\item{experiment.name}{A character value providing the name of the column identifying the experiment.}

\item{group.name}{A character value providing the name of the column of the group labels.}

\item{value.name}{A character value providing the name of the column identifying the values.}
}
\value{
A data frame with results of the chi-squared tests for each experiment.
}
\description{
sim.chisq.test.ind
}
\examples{

n <- c(50, 75, 100)
values <- LETTERS[1:4]
group.names <- paste0("group_", 1:3)
probs <- matrix(data =
c(0.25, 0.25, 0.25, 0.25, 0.4, 0.3, 0.2, 0.1, 0.2, 0.4, 0.2, 0.2),
 nrow = length(n), byrow = TRUE)
simdat.chisq.ind <- sim.chisq.ind(n = c(50, 75, 100),
 values = LETTERS[1:4], probs = probs, num.experiments = 2,
  experiment.name = "exp_id", group.name = "treatment_group",
  group.values = paste0("group_", 1:3), value.name = "category", seed = 31)


test.statistics.chisq.test.ind <- sim.chisq.test.ind(simdat.chisq.ind =
simdat.chisq.ind, correct = TRUE, experiment.name = "exp_id",
group.name = "treatment_group", value.name = "category")
}
