% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_relative.R
\name{calc_relative}
\alias{calc_relative}
\title{Calculate relative performance criteria and MCSE}
\usage{
calc_relative(
  data,
  estimates,
  true_param,
  criteria = c("relative bias", "relative mse", "relative rmse"),
  winz = Inf
)
}
\arguments{
\item{data}{data frame or tibble containing the simulation results.}

\item{estimates}{vector or name of column from \code{data} containing point
estimates.}

\item{true_param}{vector or name of column from \code{data} containing
corresponding true parameters.}

\item{criteria}{character or character vector indicating the performance
criteria to be calculated, with possible options \code{"relative bias"},
\code{"relative mse"}, and \code{"relative rmse"}.}

\item{winz}{numeric value for winsorization constant. If set to a finite
value, estimates will be winsorized at the constant multiple of the
inter-quartile range below the 25th percentile or above the 75th percentile
of the distribution. For instance, setting \code{winz = 3} will
truncate estimates that fall below P25 - 3 * IQR or above P75 + 3 * IQR.}
}
\value{
A tibble containing the number of simulation iterations, performance criteria estimate(s)
and the associated MCSE.
}
\description{
Calculates relative bias, mean squared error (relative mse), and root mean squared error (relative rmse).
The function also calculates the associated
Monte Carlo standard errors.
}
\examples{
calc_relative(data = t_res, estimates = est, true_param = true_param)


}
