% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_4way_pedigree.R
\name{sim_4way_pedigree}
\alias{sim_4way_pedigree}
\title{Simulate pedigree for 4-way intercross}
\usage{
sim_4way_pedigree(ngen = 1, nsibs = 100)
}
\arguments{
\item{ngen}{Number of intercross generations (1 or 2)}

\item{nsibs}{Vector with number of siblings in the sibships in the
last generation.}
}
\value{
A data frame with five columns: individual ID, mother ID,
father ID, sex, and generation.  Founders have \code{0} for mother
and father ID. Sex is coded 0 for female and 1 for male.
}
\description{
Simulate a 4-way cross, among four inbred lines (a table of
individual, mom, dad, sex)
}
\details{
We start with a set of 4 individuals (representing four
inbred lines), and make a pair of crosses to generate a pair of
heterozygous individuals.  These are then crosses to generate a set
of F1 individuals. If \code{ngen==1}, we stop there, with
\code{sum(nsibs)} individuals in this last generation.  If
\code{gen==2}, we generate \code{length(nsibs)} male/female pairs
of F1 offspring; these are intercrossed to generate a set of
sibships, with lengths defined by the values in \code{nsibs}.
Individuals in the last generation are alternating female/male.
}
\examples{
# 100 F1s between heterozygous parents
tab <- sim_4way_pedigree(1, 100)
# could also do this
tab2 <- sim_4way_pedigree(1, rep(10, 10))

# 120 F2s in 10 sibships each of size 12
tab3 <- sim_4way_pedigree(ngen=2, rep(12, 10))
}
\seealso{
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}},
\code{\link[=sim_ril_pedigree]{sim_ril_pedigree()}}, \code{\link[=sim_do_pedigree]{sim_do_pedigree()}},
\code{\link[=sim_ail_pedigree]{sim_ail_pedigree()}}
}
\keyword{datagen}
