% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2geno_allchr.R
\name{convert2geno_allchr}
\alias{convert2geno_allchr}
\title{Convert continuous allele information into marker genotypes for
multiple chromosomes}
\usage{
convert2geno_allchr(
  xodat,
  map,
  id = NULL,
  founder_geno = NULL,
  return.matrix = TRUE,
  shift_map = FALSE
)
}
\arguments{
\item{xodat}{The sort of detailed genotype/crossover data generated
by \code{\link[=sim_from_pedigree_allchr]{sim_from_pedigree_allchr()}}}

\item{map}{marker locations, a list with elements for each
chromosome}

\item{id}{ids for which individuals genotypes is desired}

\item{founder_geno}{Optional list of matrices (one per chromosome)
of size \code{n_founders} x \code{n_markers}, with the founder genotypes.
If coded as 1/2 (or 1/3), results are 1/2/3
genotypes. If coded as A/T/G/C/N, results are A/T/G/C/N/H
genotypes. If coded as letters A-H (in the case of 8 founders), results are
two-letter genotypes AA-HH with 36 possible values.}

\item{return.matrix}{If FALSE, the result is a list of length
\code{n_chrs}, otherwise it is converted into a matrix if size
\code{length(id)} x \code{n_markers}.}

\item{shift_map}{If TRUE, shift genetic map to start at 0}
}
\value{
If \code{founder_geno} is provided or there are just two
founders, the result is a numeric matrix of genotypes, individuals
x markers, with genotypes 1/2/3 codes for 11/12/22 genotypes. If
there are more than two founders and \code{founder_geno} are
letters, the result is a character matrix, too.

If \code{founder_geno} is not provided and there are more than two
founders, the result is a 3-dimensional array, individuals x
markers x alleles, with the third dimensional corresponding to the
maternal and paternal allele.
}
\description{
Wrap up of convert2geno to adequate multiple chromosomes.
}
\examples{
library(qtl)
# marker map
map <- sim.map(len=rep(100, 19), n.mar=10, include.x=FALSE)
# simulate AIL pedigree
tab <- sim_ail_pedigree(12, 30)
# simulate data from that pedigree
dat <- sim_from_pedigree_allchr(tab, map)
names(map) <- paste0("marker", seq(along=map))
# convert data to marker genotypes
id <- which(tab[, "gen"]==12)
geno <- convert2geno_allchr(dat, map, id)

}
\seealso{
\code{\link[=convert2geno]{convert2geno()}}
}
\keyword{utilities}
