% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effSelect.R
\name{effSelect}
\alias{effSelect}
\alias{which.effSelect}
\alias{logLik.eff}
\title{Model Selection for Effectiveness Distributions}
\usage{
effSelect(effs, method = "AIC", ...)

which.effSelect(effs, method = "AIC", ...)

\method{logLik}{eff}(object, ...)
}
\arguments{
\item{effs}{the list of candidate distributions to select from.}

\item{method}{selection method. One of \code{"AIC"} (default), \code{"BIC"}, or \code{"logLik"}.}

\item{...}{other parameters to the selection function.}

\item{object}{an effectiveness distribution.}
}
\value{
the selected disttribution (\code{effSelect}), or its index within \code{effs}
  (\code{which.effSelect}).
}
\description{
Functions to compute the log-likelihood, the Akaike Information Criterion, and the Bayesian
Information Criterion for an effectiveness distribution. \code{effSelect} and
\code{which.effSelect} are helper function for automatic selection from a given list of
candidates.
}
\examples{
ee <- effContFit(web2010ap[,5])
e <- effSelect(ee, method = "BIC")
e2 <- ee[[which.effSelect(ee, method = "BIC")]] # same as e

logLik(e)
AIC(e, k=4)
BIC(e)
}
\seealso{
\code{\link{logLik}}, \code{\link{AIC}}, \code{\link{BIC}} for details on model
  selection.

  See \code{\link{effFitAndSelect}} to fit and select automatically.
}
