% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_genotype.R
\name{sample_genotype}
\alias{sample_genotype}
\title{Sample a genotype according to allele frequencies}
\usage{
sample_genotype(freqs, loci = names(freqs), label = "U")
}
\arguments{
\item{freqs}{Allele frequencies (see \link{read_allele_freqs})}

\item{loci}{Character vector of locus names (defaults to \code{names} attribute of \code{freqs})}

\item{label}{Sample name}
}
\value{
DataFrame with columns \code{Sample Name}, \code{Locus}, \code{Allele1} and \code{Allele2}.
}
\description{
Sample a genotype according to allele frequencies
}
\details{
A genotype is sampled randomly by drawing two alleles from allele frequencies for each locus.
}
\examples{
# below we read an allele freqs and sample a genotype
filename <- system.file("extdata","FBI_extended_Cauc_022024.csv",
                        package = "simDNAmixtures")
freqs <- read_allele_freqs(filename)
sample_genotype(freqs, loci = c("D3S1358", "vWA"))
}
