% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-stand-level.R
\name{silv_stand_dominant_diameter}
\alias{silv_stand_dominant_diameter}
\title{Calculates the dominant diameter}
\usage{
silv_stand_dominant_diameter(
  diameter,
  ntrees = NULL,
  which = "assman",
  quiet = FALSE
)
}
\arguments{
\item{diameter}{Numeric vector with diameter classes}

\item{ntrees}{Optional. Numeric vector with number of trees per hectare.
Use this argument when you have aggregated data by diametric classes (see details).}

\item{which}{The method to calculate the dominant diameter (see details)}

\item{quiet}{if \code{TRUE}, messages will be supressed}
}
\value{
A numeric vector
}
\description{
Calculates the dominant diameter using Assman and Friedrich method, or
Weise method
}
\details{
The dominant diameter \eqn{D_0} is the mean diameter of the 100 thickest trees per
hectare. Therefore, \code{diameter} and \code{ntrees} should be vectors of the same length.
\itemize{
\item \bold{Assman}: calculates the \eqn{D_0} as the mean diameter of the 100 thickest
trees per hectare
\item \bold{Weise}: calculates the \eqn{D_0} as the quadratic mean diameter of the
20\% thickest trees per hectare
}
}
\examples{
## calculate d0 for inventory data grouped by plot_id and species
library(dplyr)
inventory_samples |>
mutate(dclass = silv_tree_dclass(diameter)) |>
  summarise(
    height = mean(height, na.rm = TRUE),
    ntrees = n(),
    .by    = c(plot_id, species, dclass)
  ) |>
  mutate(
    ntrees_ha = silv_density_ntrees_ha(ntrees, plot_size = 10),
    d0        = silv_stand_dominant_diameter(dclass, ntrees_ha),
    .by       = c(plot_id, species)
  )
}
