% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_graphs.R
\name{sample_gnp_signed}
\alias{sample_gnp_signed}
\title{Generate random signed graphs according to the G(n,p) Erdos-Renyi model}
\usage{
sample_gnp_signed(n, p, p_neg, directed = FALSE, loops = FALSE)
}
\arguments{
\item{n}{The number of vertices in the graph.}

\item{p}{The probability for drawing an edge between two arbitrary vertices.}

\item{p_neg}{The probability of a drawn edge to be a negative tie}

\item{directed}{logical, whether the graph will be directed. defaults to FALSE.}

\item{loops}{logical, whether to add loop edges, defaults to FALSE.}
}
\value{
a signed igraph graph object
}
\description{
Generate random signed graphs according to the G(n,p) Erdos-Renyi model
}
\examples{
sample_gnp_signed(10, 0.4, 0.5)
}
\references{
Erdos, P. and Renyi, A., On random graphs, \emph{Publicationes Mathematicae 6}, 290–297 (1959).
}
