% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/same_size_clustering.R
\name{same_size_clustering}
\alias{same_size_clustering}
\title{Same Size Clustering}
\usage{
same_size_clustering(
  mat,
  diss = FALSE,
  clsize = NULL,
  algo = c("nnit", "hcbottom", "kmvar"),
  method = c("maxd", "random", "mind", "elki", "ward.D", "average", "complete", "single")
)
}
\arguments{
\item{mat}{a data/distance matrix.}

\item{diss}{if \code{TRUE}, treat \code{mat} as a distance matrix.}

\item{clsize}{integer, number of sample within a cluster.}

\item{algo}{algorithm.}

\item{method}{method.}
}
\value{
a vector.
}
\description{
This is a wrapper for several implementation that classify samples into
same size clusters, the details please see \href{http://jmonlong.github.io/Hippocamplus/2018/06/09/cluster-same-size/}{this blog}.
The source code is modified based on code from the blog.
}
\examples{
set.seed(1234L)
x <- rbind(
  matrix(rnorm(100, sd = 0.3), ncol = 2),
  matrix(rnorm(100, mean = 1, sd = 0.3), ncol = 2)
)
colnames(x) <- c("x", "y")

y1 <- same_size_clustering(x, clsize = 10)
y11 <- same_size_clustering(as.matrix(dist(x)), clsize = 10, diss = TRUE)

y2 <- same_size_clustering(x, clsize = 10, algo = "hcbottom", method = "ward.D")

y3 <- same_size_clustering(x, clsize = 10, algo = "kmvar")
y33 <- same_size_clustering(as.matrix(dist(x)), clsize = 10, algo = "kmvar", diss = TRUE)
}
