% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_enrichment.R
\name{group_enrichment2}
\alias{group_enrichment2}
\title{Group Enrichment Analysis with Subsets}
\usage{
group_enrichment2(
  df,
  subset_var,
  grp_vars,
  enrich_vars,
  co_method = c("t.test", "wilcox.test"),
  ref_group = NA
)
}
\arguments{
\item{df}{a \code{data.frame}.}

\item{subset_var}{a column for subsetting.}

\item{grp_vars}{character vector specifying group variables to split samples
into subgroups (at least 2 subgroups, otherwise this variable will be skipped).}

\item{enrich_vars}{character vector specifying measure variables to be compared.
If variable is not numeric, only binary cases are accepted in the form of
\code{TRUE/FALSE} or \code{P/N} (P for positive cases and N for negative cases).
Of note, \code{NA} values set to negative cases.}

\item{co_method}{test method for continuous variable, default is 't.test'.}

\item{ref_group}{reference group set in \code{grp_vars}.}
}
\description{
More details see \code{\link[=group_enrichment]{group_enrichment()}}.
}
\seealso{
\link{show_group_enrichment}
}
