% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.mcmc.var}
\alias{plot.mcmc.var}
\title{Plotting method for \code{mcmc.var} objects}
\usage{
\method{plot}{mcmc.var}(x, ...)
}
\arguments{
\item{x}{\code{mcmc.var} object}

\item{...}{further arguments to be passed to \code{\link{TV_heatmap}} function.

For further details see \code{\link{TV_heatmap}} function.}
}
\value{
Called for its side effects and returns invisibly.
}
\description{
Plotting method for \code{mcmc.var} objects
}
\examples{
\donttest{
set.seed(123)
sim <- simTVPVAR(p = 2)
data <- sim$data

res <- shrinkTVPVAR(data, p = 2)

plot(res$theta_sr)
}
}
\seealso{
Other plotting functions: 
\code{\link{TV_heatmap}()},
\code{\link{density_plotter}()},
\code{\link{plot.mcmc.tvp.var}()},
\code{\link{plot.shrinkTVPVAR}()},
\code{\link{plot.shrinkTVPVAR_fit}()},
\code{\link{plot.shrinkTVPVAR_forc}()},
\code{\link{state_plotter}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{plotting functions}
