% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shorts-S3.R
\name{plot.shorts_model}
\alias{plot.shorts_model}
\title{S3 method for plotting \code{shorts_model} object}
\usage{
\method{plot}{shorts_model}(x, type = "model", ...)
}
\arguments{
\item{x}{\code{shorts_model} object}

\item{type}{Type of plot. Can be "model" (default), "kinematics-time",
"kinematics-distance", or "residuals"}

\item{...}{Not used}
}
\value{
\code{\link[ggplot2]{ggplot}} object
}
\description{
S3 method for plotting \code{shorts_model} object
}
\examples{
# Simple model with radar gun data
instant_velocity <- data.frame(
  time = c(0, 1, 2, 3, 4, 5, 6),
  velocity = c(0.00, 4.99, 6.43, 6.84, 6.95, 6.99, 7.00)
)

radar_model <- with(
  instant_velocity,
  model_radar_gun(time, velocity)
)

plot(radar_model)
plot(radar_model, "kinematics-time")
plot(radar_model, "kinematics-distance")
plot(radar_model, "residuals")
}
