% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-splits.R
\name{format_splits}
\alias{format_splits}
\title{Format Split Data}
\usage{
format_splits(distance, time)
}
\arguments{
\item{distance}{Numeric vector}

\item{time}{Numeric vector}
}
\value{
Data frame with the following columns:
    \describe{
         \item{split}{Split number}
         \item{split_distance_start}{Distance at which split starts}
         \item{split_distance_stop}{Distance at which split ends}
         \item{split_distance}{Split distance}
         \item{split_time_start}{Time at which distance starts}
         \item{split_time_stop}{Time at which distance ends}
         \item{split_time}{Split time}
         \item{split_mean_velocity}{Mean velocity over split distance}
         \item{split_mean_acceleration}{Mean acceleration over split distance}
    }
}
\description{
Function formats split data and calculates split distances, split times and average split velocity
}
\examples{
data("split_times")

john_data <- split_times[split_times$athlete == "John", ]

format_splits(john_data$distance, john_data$time)
}
