% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-module.R
\name{quiz_ui}
\alias{quiz_ui}
\alias{quiz_server}
\title{Run a quiz in 'shiny'}
\usage{
quiz_ui(quiz)

quiz_server(quiz)
}
\arguments{
\item{quiz}{an object of class \code{quiz}. See \code{\link[=create_quiz]{create_quiz()}}}
}
\value{
a reactive object showing the current results of the quiz
}
\description{
A 'shiny' module to implement a quiz. These are the core functions to implement the quiz with a 'shiny' application.
}
\section{Functions}{
\itemize{
\item \code{quiz_ui()}: UI side function

\item \code{quiz_server()}: Server side function

}}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
quiz <- create_quiz(
  create_question(
    'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Select nulla.',
    add_choice('auctor'),
    add_choice('nulla', correct = TRUE)
  ),
  create_question(
    'Mauris congue aliquet dui, ut dapibus lorem porttitor sed. Select 600.',
    add_choice('600', correct = TRUE),
    add_choice('800')
  )
)

ui <- shiny::fluidPage(
  htmltools::div(
    style = "max-width: 700px",
    quiz_ui(quiz)
   )
 )
server <- function(input, output, session) {
 quiz_server(quiz)
}
shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=create_quiz]{create_quiz()}} \code{\link[=preview_app]{preview_app()}}
}
\author{
Joseph Marlo
}
