
<!-- README.md is generated from README.Rmd. Please edit that file -->

# shinyproxyLogs

<!-- badges: start -->
<!-- badges: end -->

shinyproxyLogs is an R package designed to simplify the process of
parsing and analyzing log files generated by ShinyProxy containers. The
package provides a set of functions that allow users to extract metadata
from log filenames and compute summary statistics from log content. This
helps system administrators and developers quickly identify issues such
as errors, warnings, and fatal events in their ShinyProxy logs.

# Project Goal

The primary goal of shinyproxyLogs is to automate and streamline the log
analysis process for ShinyProxy environments. Specifically, the package:

- **Parses Log File Names**: Extracts important metadata such as
  `specId`, `proxyId`, `startupTime`, and `logType` from the log file
  names.
- **Analyzes Log Content**: Reads the log files and computes statistics
  including the total number of lines, and counts of error, warning, and
  fatal messages.
- **Provides Summary Reports**: Aggregates data by container (based on
  the metadata) to offer a concise overview of the container logs.

# Prerequisites

**Access Rights:** To use shinyproxyLogs, you must have the necessary
access rights to the `shinyproxy` folder. This folder contains the logs
from the ShinyProxy container, and without proper permissions, the
package will not be able to read or process the log files. Please ensure
that you have the required read and access permissions to the ShinyProxy
logs directory before using this package.

## Installation

You can install the development version of shinyproxyLogs like so:

``` r
install.packages("devtools")
devtools::install_github("tsenegas/shinyproxyLogs")
```

## Example

This is a basic example which shows you how to solve a common problem:

``` r
library(shinyproxyLogs)
## basic example code
analyze_logs(path_container_logs = '../../shinyproxy/shinyproxy/container-logs/logs/')
#> $file_info
#> # A tibble: 30 × 10
#>    specId     proxyId        startupTime logType filePath numLines numErrorLines
#>    <chr>      <chr>          <chr>       <chr>   <chr>       <int>         <int>
#>  1 01_hello   07b3eece-65d8… 05_Feb_202… stderr  ../../s…        3             0
#>  2 01_hello   07b3eece-65d8… 05_Feb_202… stdout  ../../s…       20             0
#>  3 01_hello   34da9fa1-5e3b… 13_Feb_202… stderr  ../../s…        3             0
#>  4 01_hello   34da9fa1-5e3b… 13_Feb_202… stdout  ../../s…       20             0
#>  5 01_hello   9128a3d1-e722… 09_Feb_202… stderr  ../../s…        3             0
#>  6 01_hello   9128a3d1-e722… 09_Feb_202… stdout  ../../s…       20             0
#>  7 01_hello   d1ea989c-4bde… 09_Feb_202… stderr  ../../s…        3             0
#>  8 01_hello   d1ea989c-4bde… 09_Feb_202… stdout  ../../s…       20             0
#>  9 06_tabsets 30c5e8cf-9c16… 13_Feb_202… stderr  ../../s…        3             0
#> 10 06_tabsets 30c5e8cf-9c16… 13_Feb_202… stdout  ../../s…       20             0
#> # ℹ 20 more rows
#> # ℹ 3 more variables: numWarningLines <int>, numFatalLines <int>,
#> #   numInfoLines <int>
#> 
#> $summary
#> # A tibble: 15 × 9
#>    specId        proxyId startupTime stdout_lines stderr_lines total_error_lines
#>    <chr>         <chr>   <chr>              <int>        <int>             <int>
#>  1 01_hello      07b3ee… 05_Feb_202…           20            3                 0
#>  2 01_hello      34da9f… 13_Feb_202…           20            3                 0
#>  3 01_hello      9128a3… 09_Feb_202…           20            3                 0
#>  4 01_hello      d1ea98… 09_Feb_202…           20            3                 0
#>  5 06_tabsets    30c5e8… 13_Feb_202…           20            3                 0
#>  6 06_tabsets    f80074… 05_Feb_202…           20            3                 0
#>  7 crash_simula… 0801f3… 05_Feb_202…           20            4                 0
#>  8 crash_simula… 10e989… 05_Feb_202…           20            3                 0
#>  9 crash_simula… 206d99… 05_Feb_202…           20            9                 2
#> 10 crash_simula… 278b89… 13_Feb_202…           20           11                 2
#> 11 crash_simula… 2b58f9… 09_Feb_202…           20            3                 0
#> 12 crash_simula… 34e115… 05_Feb_202…           20            4                 0
#> 13 crash_simula… 43c8bf… 05_Feb_202…           20            8                 2
#> 14 crash_simula… e0399e… 05_Feb_202…           20            7                 0
#> 15 crash_simula… e65af8… 05_Feb_202…           20            3                 0
#> # ℹ 3 more variables: total_warning_lines <int>, total_fatal_lines <int>,
#> #   total_info_lines <int>
```
