% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfiles.R
\docType{data}
\name{modules}
\alias{modules}
\title{Sample data for the shinymgr.sqlite table, "modules"}
\format{
A data frame with 8 observations on the following 7 variables.
}
\usage{
data(demo_data)
}
\description{
Sample data imported to the shinymgr SQLite database
 by the function \code{\link{shiny_db_populate}}.
}
\details{
-----------------------------------------------------------

New records to "modules" table are added to the 
shinymgr.sqlite database via the  \code{\link{mod_register}} function.
}
\section{Fields}{

\describe{
\item{\code{pkModuleName}}{Name of a module; primary key.}

\item{\code{modDisplayName}}{Name displayed on the module.}

\item{\code{modDescription}}{Description of the module.}

\item{\code{modCitation}}{Citation of the module.}

\item{\code{modNotes}}{Notes on the module.}

\item{\code{modActive}}{Logical. Is the module still active?}

\item{\code{dateCreated}}{Date the module was created.}
}}

\examples{

# read in the demo data
data(demo_data)

# look at the structure
str(modules)

}
\seealso{
Other data: 
\code{\link{appReports}},
\code{\link{appStitching}},
\code{\link{appTabs}},
\code{\link{apps}},
\code{\link{modFunctionArguments}},
\code{\link{modFunctionReturns}},
\code{\link{modPackages}},
\code{\link{reports}},
\code{\link{tabModules}},
\code{\link{tabs}}
}
\concept{data}
