% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderInput.R
\name{updateOrderInput}
\alias{updateOrderInput}
\title{Change the value of an orderInput on the client}
\usage{
updateOrderInput(
  session,
  inputId,
  label = NULL,
  items = NULL,
  connect = NULL,
  item_class = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{inputId}{The \code{input} slot that will be used to access the current order
of items.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{items}{Items to display, can be a list, an atomic vector or a factor.
For list or atomic vector, if named, the names are displayed and the order
is given in values. For factor, values are displayed and the order is given
in levels}

\item{connect}{Optional. Allow items to be dragged between \code{orderInput}s.
Should be a vector of \code{inputId}(s) of other \code{orderInput}(s) that the items
from this \code{orderInput} should be connected to.}

\item{item_class}{One of the \href{https://getbootstrap.com/docs/4.0/utilities/colors/}{Bootstrap color utility classes} to apply to
each item.}
}
\description{
Similar to the input updater functions of shiny package, this function send a
message to the client, telling it to change the settings of an \link{orderInput}
object. Any arguments with NULL values will be ignored; they will not result
in any changes to the input object on the client. The function can't update
the "source" \code{orderInput}s.
}
\examples{
library(shiny)

if (interactive()) {

  ui <- fluidPage(
    orderInput("foo", "foo",
               items = month.abb[1:3],
               item_class = 'info'),
    verbatimTextOutput("order"),
    actionButton("update", "update")
  )

  server <- function(input, output, session) {
    output$order <- renderPrint({input$foo})
    observeEvent(input$update, {
      updateOrderInput(session, "foo",
                       items = month.abb[1:6],
                       item_class = "success")
    })
  }

  shinyApp(ui, server)

}
}
