% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secure-app.R
\name{secure-app}
\alias{secure-app}
\alias{secure_app}
\alias{secure_server}
\alias{create_server}
\title{Secure a Shiny application and manage authentication}
\usage{
secure_app(
  ui,
  ...,
  head_auth = NULL,
  theme = NULL,
  language = "en",
  fab_position = "bottom-right"
)

secure_server(
  check_credentials,
  timeout = 15,
  inputs_list = NULL,
  keep_token = FALSE,
  validate_pwd = NULL,
  update_credentials = NULL,
  session = shiny::getDefaultReactiveDomain()
)

create_server(check_credentials, update_credentials, server_fn)
}
\arguments{
\item{ui}{UI of the application.}

\item{...}{Arguments passed to \code{\link{auth_ui}}.}

\item{head_auth}{Tag or list of tags to use in the \code{<head>}
of the authentication page (for custom CSS for example).}

\item{theme}{Alternative Bootstrap stylesheet, default is to use \code{readable},
you can use themes provided by \code{shinythemes}.
It will affect the authentication panel and the admin page.}

\item{language}{Language to use for labels, supported values are : "en", "es".}

\item{fab_position}{Position for the FAB button, see \code{\link{fab_button}} for options.}

\item{check_credentials}{Function passed to \code{\link{auth_server}}.}

\item{timeout}{Timeout session (minutes) before logout if sleeping. Defaut to 15. 0 to disable.}

\item{inputs_list}{\code{list}. If database credentials, you can configure inputs for editing users information. See Details.}

\item{keep_token}{Logical, keep the token used to authenticate in the URL, it allow to refresh the
application in the browser, but careful the token can be shared between users ! Default to \code{FALSE}.}

\item{validate_pwd}{A \code{function} to validate the password enter by the user.
Default is to check for the password to have at least one number, one lowercase,
one uppercase and be of length 6 at least.}

\item{update_credentials}{Function passed to \code{\link{chpass_server}}.}

\item{session}{Shiny session.}

\item{server_fn}{Function that returns the authenticated server.}
}
\value{
A \code{reactiveValues} containing informations about the user connected.
}
\description{
Secure a Shiny application and manage authentication
}
\details{
If database credentials, you can configure inputs with \code{inputs_list} for editing users information
from the admin console. \code{start}, \code{expire}, \code{admin} and \code{password} are not configurable.
The others columns are rendering by defaut using a \code{textInput}. You can modify this using \code{inputs_list}.
\code{inputs_list} must be a named list. Each name must be a column name, and then we must have the function
 shiny to call \code{fun} and the arguments \code{args} like this :
 \code{
 list(group = list(
     fun = "selectInput",
     args = list(
         choices = c("all", "restricted"),
         multiple = TRUE,
         selected = c("all", "restricted")
      )
     )
)
}

You can specify if you want to allow downloading users file,  sqlite database and logs from within
the admin panel by invoking \code{options("shinydbauth.download")}. It defaults
to \code{c("db", "logs", "users")}, that allows downloading all. You can specify
\code{options("shinydbauth.download" = "db"} if you want allow admin to download only
sqlite database, \code{options("shinydbauth.download" = "logs")} to allow logs download
or \code{options("shinydbauth.download" = "")} to disable all.

Using \code{options("shinydbauth.pwd_validity")}, you can set password validity period. It defaults
to \code{Inf}. You can specify for example
\code{options("shinydbauth.pwd_validity" = 90)} if you want to force user changing password each 90 days.

Using \code{options("shinydbauth.pwd_failure_limit")}, you can set password failure limit. It defaults
to \code{Inf}. You can specify for example
\code{options("shinydbauth.pwd_failure_limit" = 5)} if you want to lock user account after 5 wrong password.

\code{\link{create_server}} calls \code{\link{secure_server}} and, if authentication is ok, passes user_info to server_fn
}
\note{
A special input value will be accessible server-side with \code{input$shinydbauth_where}
 to know in which step user is : authentication, application, admin or password.
}
