pkgEnv <- new.env()

pkgEnv$label_en = list(
  "Please authenticate" = "Please authenticate",
  "Username:" = "Username :",
  "Password:" = "Password :",
  "Login" = "Login",
  "Username or password are incorrect" = "Username or password are incorrect",
  "Your account has expired" = "Your account has expired",
  "Your account is locked" = "Your account is locked",
  "Please change your password" = "Please change your password",
  "New password cannot be the same as old" = "New password cannot be the same as old",
  "New password:" = "New password :",
  "Current password:" = "Current password :",
  "Confirm password:" = "Confirm password :",
  "Update new password" = "Update new password",
  "Password successfully updated! Please re-login" = "Password successfully updated! Please re-login",
  "The two passwords are different" = "The two passwords are different",
  "Failed to update password" = "Failed to update password",
  "Logout" = "Logout",
  "Go to application" = "Go to application",
  "Administrator mode" = "Administrator mode",
  "Add a user" = "Add a user",
  "Too many users" = "Too many users",
  "Maximum number of users : %s" = "Maximum number of users : %s",
  "Failed to update user" = "Failed to update user",
  "User successfully updated" = "User successfully updated",
  "Cancel" = "Cancel",
  "Confirm new user" = "Confirm new user",
  "Confirm change" = "Confirm change",
  "Are you sure to remove user(s): %s from the database ?" = "Are you sure to remove user(s): %s from the database ?",
  "Delete user(s)" = "Delete user(s)",
  "Delete user" = "Delete user",
  "Edit user" = "Edit user",
  "User already exist!" = "User already exist!",
  "Dismiss" = "Dismiss",
  "New user %s succesfully created!" = "New user %s succesfully created!",
  "Ask to change password" = "Ask to change password",
  "Confirm" = "Confirm",
  "Ask %s to change password on next connection?" = "Ask %s to change password on next connection?",
  "Change saved!" = "Change saved!",
  "Failed to update the database" = "Failed to update the database",
  "Password does not respect safety requirements" = "Password does not respect safety requirements",
  "Password must be defined" = "Password must be defined",
  "Password must contain at least one number, one lowercase, one uppercase and must be at least length 6." = "Password must contain at least one number, one lowercase, one uppercase and must be at least length 6.",
  "Number of connections per user" = "Number of connections per user",
  "Number of connections per day" = "Number of connections per day",
  "Total number of connection" = "Total number of connection",
  "You can\'t remove yourself!" = "You can\'t remove yourself!",
  "User:" = "User :",
  "Period:" = "Period :",
  "Last week" = "Last week",
  "Last month" = "Last month",
  "All period" = "All period",
  "Home" = "Home",
  "Select all shown users" = "Select all shown users",
  "Remove selected users" = "Remove selected users",
  "Edit selected users" = "Edit selected users",
  "Force selected users to change password" = "Force selected users to change password",
  "Users" = "Users",
  "Passwords" = "Passwords",
  "Download logs database" = "Download logs database",
  "Download SQL database" = "Download SQL database",
  "Download Users file" = "Download Users file",
  "Reset password for %s?" = "Reset password for %s?",
  "Reset password" = "Reset password",
  "Temporary password:" = "Temporary password:",
  "Password succesfully reset!" = "Password succesfully reset!",
  "You are not authorized for this application" = "You are not authorized for this application",
  "Language"  = "Language",
  "Yes" = "Yes",
  "No" = "No",
  "Password" = "Password",
  "start" = "start",
  "expire" = "expire",
  "admin" = "Admin",
  "user" = "User",
  "Edit" = "Edit",
  "Remove" = "Remove",
  "must_change" = "Must Change",
  "have_changed" = "Have Changed",
  "date_change" = "Date",
  "Change password" = "Change password",
  "Select" = "Select",
  "Logs" = "Logs",
  "All users" = "All users",
  "Nb logged" = "Nb logged",
  "Allowed null values" = "Allowed null values"
)

pkgEnv$label_es = list(
  "Please authenticate" = "Favor de autenticarse",
  "Username:" = "Usuario:",
  "Password:" = "Contrase\u00f1a:",
  "Login" = "Iniciar sesi\u00f3n",
  "Username or password are incorrect" = "Usuario o contrase\u00f1a incorrecto",
  "Your account has expired" = "Su cuenta ha expirado",
  "Your account is locked" = "Your account  est\u00e1 bloqueada",
  "Please change your password" = "Por favor, cambie su contrase\u00f1a",
  "New password cannot be the same as old" = "La nueva contrase\u00f1a no puede ser la misma que la anterior",
  "New password:" = "Nueva contrase\u00f1a:",
  "Current password:" = "Contrase\u00f1a Actual:",
  "Confirm password:" = "Confirme contrase\u00f1a:",
  "Update new password" = "Actualizar nueva contrase\u00f1a",
  "Password successfully updated! Please re-login" = "\u00a1Cambio de contrase\u00f1a exitoso! Por favor, vuelva a iniciar sesi\u00f3n",
  "The two passwords are different" = "Las dos contrase\u00f1as son diferentes",
  "Failed to update password" = "Fall\u00f3 la actualizaci\u00f3n de la contrase\u00f1a",
  "Logout" = "Cerrar sesi\u00f3n",
  "Go to application" = "Ir a aplicaci\u00f3n",
  "Administrator mode" = "Modo administraci\u00f3n",
  "Add a user" = "Agregar usuario",
  "Too many users" = "Demasiado usuario",
  "Maximum number of users : %s" = "N\u00famero m\u00e1ximo de usuarios : %s",
  "Failed to update user" = "Fall\u00f3 la actualizaci\u00f3n del usuario",
  "User successfully updated" = "Usuario actualizado correctamente",
  "Cancel" = "Cancelar",
  "Confirm new user" = "Confirmar nuevo usuario",
  "Confirm change" = "Confirmar cambio",
  "Are you sure to remove user(s): %s from the database ?" = "\u00bfEst\u00e1 seguro de remover el(los) usuario(s): %s de la base de datos?",
  "Delete user(s)" = "Borrar usuario(s)",
  "Delete user" = "Borrar usuario",
  "Edit user" = "Editar usuario",
  "User already exist!" = "\u00a1Usuario ya existente!",
  "Dismiss" = "Descartar",
  "New user %s succesfully created!" = "\u00a1Nuevo usuario %s creado satisfactoriamente!",
  "Ask to change password" = "Pedir que cambie la contrase\u00f1a",
  "Confirm" = "Confirmar",
  "Ask %s to change password on next connection?" = "\u00bfDesea pedir a %s que cambie la contrase\u00f1a en su siguiente connexi\u00f3n?",
  "Change saved!" = "\u00a1Cambio guardado!",
  "Failed to update the database" = "Fall\u00f3 la actualizaci\u00f3n de la base de datos",
  "Password does not respect safety requirements" = "La contrase\u00f1a no contiene los requerimientos de seguridad",
  "Password must be defined" = "La contrase\u00f1a debe ser definida",
  "Password must contain at least one number, one lowercase, one uppercase and must be at least length 6." = "La contrase\u00f1a debe contener al menos un n\u00famero, una m\u00ednuscula, una may\u00fascula y debe ser de almenos seis caracteres.",
  "Number of connections per user" = "N\u00famero de conexiones por usuario",
  "Number of connections per day" = "N\u00famero de conexiones por d\u00eda",
  "Total number of connection" = "Total de conexiones",
  "You can\'t remove yourself!" = "No puede eliminarse usted mismo",
  "User:" = "Usuario:",
  "Period:" = "Periodo:",
  "Last week" = "Semana pasada",
  "Last month" = "Mes pasado",
  "All period" = "Todo el periodo",
  "Home" = "Inicio",
  "Select all shown users" = "Seleccionar todos los usuarios mostrados",
  "Remove selected users" = "Remover los usuarios seleccionados",
  "Edit selected users" = "Editar los usuarios seleccionados",
  "Force selected users to change password" = "Forzar a los usuarios seleccionados que cambien la contrase\u00f1a",
  "Users" = "Usuarios",
  "Passwords" = "Contrase\u00f1as",
  "Download logs database" = "Descargar la base de datos de registros",
  "Download SQL database" = "Descargar la base de datos SQL",
  "Download Users file" = "Descargar la base de datos de los usuarios",
  "Reset password for %s?" = "\u00bfReiniciar contrase\u00f1a para %s?",
  "Reset password" = "Reiniciar",
  "Temporary password:" = "Contrase\u00f1a temporal:",
  "Password succesfully reset!" = "\u00a1Contrase\u00f1a reiniciada satisfactoriamente!",
  "You are not authorized for this application" = "No est\u00e1s autorizado para esta aplicaci\u00f3n",
  "Language" = "Lenguaje",
  "Yes" = "S\u00ed",
  "No" = "No",
  "Password" = "Contrase\u00f1a",
  "start" = "empieza",
  "expire" = "expira",
  "admin" = "administrador",
  "user" = "usuario",
  "Edit" = "Editar",
  "Remove" = "Eliminar",
  "must_change" = "Cambiar\u00e1 contrase\u00f1a",
  "have_changed" = "Cambi\u00f3 contrase\u00f1a",
  "date_change" = "Fecha de cambio",
  "Change password" = "Cambiar",
  "Select" = "Seleccionar",
  "Logs" = "Registros",
  "All users" = "Todos los usuarios",
  "Nb logged" = "Conexiones",
  "Allowed null values" = "Valores nulos permitidos"
)


v_language_registered = c("en", "es")
names(v_language_registered) = c("English", "Espa\u00f1ol")


#' @importFrom R6 R6Class
#' @importFrom utils modifyList
language <- R6::R6Class(
  classname = "shinydbauth_language",
  public = list(
    initialize = function() {
      invisible(self)
    },
    set_language = function(lan) {
      if (!lan %in% private$language_registered) {
        stop("Unsupported language !", call. = FALSE)
      }
      private$language <- lan
      private$labels <-   switch(lan,
                                  "en" = pkgEnv$label_en,
                                  "es" = pkgEnv$label_es,
      )
    },
    get = function(label) {
      value <- private$labels[[label]]
      if (is.null(value)) {
        label
      } else {
        value
      }
    },
    get_all = function() {
      private$labels
    },
    get_DT = function() {
      private$DT_lan[[private$language]]
    },
    get_dateInput = function() {
      private$dateInput_lan[[private$language]]
    },
    get_language_registered = function() {
      private$language_registered
    },
    get_language = function() {
      private$language
    }
  ),
  private = list(
    language = "en",
    language_registered = v_language_registered,
    labels = pkgEnv$label_en,
    dateInput_lan = list(
      "en" = "en",
      "es" = "es"
    ),
    DT_lan = list(
      en = list(
        sEmptyTable = "No data available in table",
        sInfo = "Showing _START_ to _END_ of _TOTAL_ entries",
        sInfoEmpty = "Showing 0 to 0 of 0 entries",
        sInfoFiltered = "(filtered from _MAX_ total entries)",
        sInfoPostFix = "",
        sInfoThousands = ",",
        sLengthMenu = "Show _MENU_ entries",
        sLoadingRecords = "Loading...",
        sProcessing = "Processing...",
        sSearch = "Search:",
        sZeroRecords = "No matching records found",
        oPaginate = list(
          sFirst = "First",
          sLast = "Last",
          sNext = "Next",
          sPrevious = "Previous"
        ),
        oAria = list(
          sSortAscending = ": activate to sort column ascending",
          sSortDescending = ": activate to sort column descending"
        )
      ),
      es = list(
        sEmptyTable = "No se encontraron resultados",
        sInfo = "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        sInfoEmpty = "Mostrando registros del 0 al 0 de 0 registros",
        sInfoFiltered = "(filtrado de un total de _MAX_ registros)",
        sInfoPostFix = "",
        sInfoThousands = ",",
        sLengthMenu = "Mostrar _MENU_ registros",
        sLoadingRecords = "Cargando...",
        sProcessing = "Procesando...",
        sSearch = "Buscar:",
        sZeroRecords = "No se encontraron resultados",
        oPaginate = list(
          sFirst = "Primera",
          sLast = "\u00daltima",
          sNext = "Siguiente",
          sPrevious = "Anterior"
        ),
        oAria = list(
          sSortAscending = ": activar para ordenar la columna de forma ascendente",
          sSortDescending = ": activar para ordenar la columna de forma descendente"
        )
      )
    ),
    length = function() base::length(private$labels)
  )
)


#' @title Use shinydbauth labels
#'
#' @description See all labels registered with \code{get_labels()},
#'  then set custom text with \code{set_labels()}.
#'
#' @param lan Language to use for labels, supported values are : "en", "es".
#'
#' @return A language object
#' @export
#'
#'
#' @examples
#'
#' use_language(lan = "en")
#'
use_language <- function(lan = "en") {
  lang <- language$new()
  lang$set_language(lan)
  lang
}

#' @title Modify shinydbauth labels to use custom text
#'
#' @description See all labels registered with \code{get_labels()},
#'  then set custom text with \code{set_labels()}.
#'
#' @param language Language to use for labels, supported values are :  "en", "es".
#' @param ... A named list with labels to replace.
#'
#' @return \code{get_labels()} return a named list with all labels registered.
#' @export
#'
#' @name custom-labels
#'
#' @examples
#'
#' # In global.R for example:
#' set_labels(
#'   language = "en",
#'   "Please authenticate" = "You have to login",
#'   "Username:" = "What's your name:",
#'   "Password:" = "Enter your password:"
#' )
set_labels <- function(language, ...) {
  
  if (!language %in% c("en", "es")) {
    stop("Only supported language for the now are: en, es", call. = FALSE)
  }
  args <- list(...)
  if (!all(nzchar(names(args)))) {
    stop("All arguments must be named!", call. = FALSE)
  }

  current_labels <- switch(language,
                   "en" = pkgEnv$label_en,
                   "es" = pkgEnv$label_es
  )

  update_labels <- modifyList(
    x = current_labels,
    val = lapply(args, I)
  )

  if (language %in% "en") {
    pkgEnv$label_en <- update_labels
  } else if (language %in% "es") {
    pkgEnv$label_es <- update_labels
  }

  invisible(TRUE)
}

#' @export
#'
#' @rdname custom-labels
get_labels <- function(language = "en") {

  if (!language %in% c("en", "es")) {
    warning("Only supported language for the now are: en, es", call. = FALSE)
    language <- "en"
  }

  switch(language,
          "en" = pkgEnv$label_en,
          "es" = pkgEnv$label_es,
  )
}
