% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/withloader.R
\name{marquee}
\alias{marquee}
\title{Create a marquee list.}
\usage{
marquee(content, behavior = "scroll", direction = "left",
  scrollamount = 6, width = "100\%", ...)
}
\arguments{
\item{content}{The text content of the marquee.}

\item{behavior}{Sets how the text is scrolled within the marquee. Possible values are scroll, slide and alternate. If no value is specified, the default value is scroll.}

\item{direction}{Sets the direction of the scrolling within the marquee. Possible values are left, right, up and down. If no value is specified, the default value is left.}

\item{scrollamount}{Sets the amount of scrolling at each interval in pixels. The default value is 6.}

\item{width}{Sets the width in pixels or percentage value.}

\item{...}{Other parameters passed to the marquee such as height, bgcolor.}
}
\description{
This creates the necessary elements for marquee to make custom text loading screen.
This function is to be used as input list in withLoader or renderCSS functions.
}
\examples{
marquee("Custom loading text here...", height=60, width=100)
}
