% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busy-bar.R
\name{manual-progressbar}
\alias{manual-progressbar}
\alias{use_busy_bar}
\alias{update_busy_bar}
\title{Manual busy indicator (progress bar)}
\usage{
use_busy_bar(color = "#112446", centered = FALSE, height = "8px")

update_busy_bar(value, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{color}{Progress bar color.}

\item{centered}{Center the progress bar or not.}

\item{height}{Height of the bar.}

\item{value}{The new value for the progress bar.}

\item{session}{Shiny session.}
}
\description{
Declare \code{use_busy_bar()} in your UI and update value server-side with \code{update_busy_bar()}.
}
\examples{
library(shiny)
library(shinybusy)

ui <- fluidPage(
  tags$h2("Manual nanobar"),
  use_busy_bar(color = "#01DF01", height = "15px"),
  actionButton(inputId = "go", label = "Go"),
  sliderInput(
    inputId = "set", label = "Set progress",
    min = 0, value = 0, max = 100
  )
)

server <- function(input, output, session) {

  observeEvent(input$go, {
    update_busy_bar(0)
    for (i in 1:100) {
      Sys.sleep(0.1)
      update_busy_bar(i)
    }
  })

  observeEvent(input$set, {
    update_busy_bar(input$set)
  })

}

if (interactive()) {
  shinyApp(ui, server)
}
}
