% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_os}
\alias{get_os}
\alias{get_os_version}
\title{Get user's operating system}
\usage{
get_os()

get_os_version()
}
\value{
User's detected operating system

User's detected operating system version
}
\description{
Get the user's operating system (such as "Windows" or "Mac" or "Android") and version
(such as "10" for Windows or "OS X" for Mac).\cr\cr
The value is reactive, therefore it must be accessed inside a reactive context
(such as an \link[shiny:observe]{observe} or \link[shiny:reactive]{reactive}).\cr\cr
\{shinybrowser\} must be initialized with a call to \code{\link[=detect]{detect()}} in the app's ui.
}
\section{Accuracy}{

It's important to understand there is no reliable way to detect the
information in \{shinybrowser\} with 100\% accuracy.\cr\cr\{shinybrowser\} makes
a best effort at identifying the most accurate information, but some
browser/operating system combinations may be difficult to identify. Users
can also use a variety of tools to deliberately spoof this information.\cr\cr
With that in mind, \{shinybrowser\} should detect the correct information in
most cases.
}

\section{Supported values}{

Only major browsers and operating systems are supported, which means that the
RStudio Viewer may result in an "UNKNOWN" browser, and unpopular operating systems
may also result in "UNKNOWN".\cr\cr
For a list of values that can be detected, see \link{SUPPORTED_BROWSERS},
\link{SUPPORTED_DEVICES}, and \link{SUPPORTED_OPERATING_SYSTEMS}.
}

\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    shinybrowser::detect(),
    "Your operating system:",
    textOutput("os_info")
  )
  server <- function(input, output, session) {
    output$os_info <- renderText({
      paste(shinybrowser::get_os(), "version", shinybrowser::get_os_version())
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=detect]{detect()}}, \code{\link[=get_all_info]{get_all_info()}}, \code{\link[=is_os_windows]{is_os_windows()}},
\code{\link[=is_os_mac]{is_os_mac()}}, \link{SUPPORTED_OPERATING_SYSTEMS}
}
