% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{registerThemeDependency}
\alias{registerThemeDependency}
\title{Register a theme dependency}
\usage{
registerThemeDependency(func)
}
\arguments{
\item{func}{A function that takes one argument, \code{theme} (which is a
\code{\link[sass:sass_layer]{sass::sass_layer()}} object), and returns an htmlDependency object, or list
of them.}
}
\description{
This function registers a function that returns an
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} or list of such objects. If
\code{session$setCurrentTheme()} is called, the function will be re-executed, and
the resulting html dependency will be sent to the client.
}
\details{
Note that \code{func} should \strong{not} be an anonymous function, or a function which
is defined within the calling function. This is so that,
\code{registerThemeDependency()} is called multiple times with the function, it
tries to deduplicate them
}
\keyword{internal}
