% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview_mobile.R
\name{preview_mobile}
\alias{preview_mobile}
\title{Allow to preview a given app on different devices.}
\usage{
preview_mobile(
  appPath = NULL,
  url = NULL,
  port = 3838,
  device = c("iphoneX", "galaxyNote8", "iphone8", "iphone8+", "iphone5s", "iphone5c",
    "ipadMini", "iphone4s", "nexus5", "galaxyS5", "htcOne"),
  color = NULL,
  landscape = FALSE
)
}
\arguments{
\item{appPath}{App to preview if local.}

\item{url}{App to preview if online.}

\item{port}{Default port. Ignored if url is provided.}

\item{device}{Wrapper devices.}

\item{color}{Wrapper color. Only with iphone8 (black, silver, gold),
iphone8+ (black, silver, gold), iphone5s (black, silver, gold),
iphone5c (white,red , yellow, green, blue), iphone4s (black, silver), ipadMini (black, silver) and
galaxyS5 (black, white).}

\item{landscape}{Whether to put the device wrapper in landscape mode. Default to FALSE.}
}
\value{
A shiny app containing an iframe surrounded by the device wrapper.
}
\description{
Allow to preview a given app on different devices.
}
\note{
choose either url or appPath!
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 preview_mobile(appPath = "~/whatever", device = "galaxyNote8")
}
}
