% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lottie_setDirection.R
\name{lottie_setDirection}
\alias{lottie_setDirection}
\title{Adjust 'Lottie' Animation Direction}
\usage{
lottie_setDirection(
  direction = 1,
  name = "all",
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{direction}{Either \code{1} for forward playback or \code{-1} for reverse playback.}

\item{name}{A character string specifying the name of the 'Lottie' animation to control.
The default of "\code{all}" will control all animations within the 'shiny' application.}

\item{session}{The 'shiny' session object. Defaults to the current reactive domain.}
}
\value{
This function is called for a side effect, and so there is no return value.
}
\description{
Adjust the playback direction of an existing 'Lottie' animation.
}
\details{
Sends a custom session message \code{"lottie_js_setDirection"} containing the function arguments.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shinyLottie)

ui <- fluidPage(
  include_lottie(),
  lottie_animation(
    path = "shinyLottie/example.json",
    name = "my_animation"
  ),
  actionButton("forwards", "Play Forwards"),
  actionButton("backwards", "Play Backwards")
)

server <- function(input, output, session) {
  observeEvent(input$forwards, {
    lottie_setDirection(direction = 1, name = "my_animation")
  })

  observeEvent(input$backwards, {
    lottie_setDirection(direction = -1, name = "my_animation")
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{lottie_animation_methods}} for similar methods.
}
