% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_input.R
\name{select_Input}
\alias{select_Input}
\title{Select Function}
\usage{
select_Input(inputId, label, select_text, select_value)
}
\arguments{
\item{inputId}{Input id for the component}

\item{label}{Insert the text for the label.}

\item{select_text}{Add the text that will apply in the drop down as a list}

\item{select_value}{Add the value that will be used for each selection.}
}
\value{
a select input html shiny object
}
\description{
This function inserts a select box
}
\examples{
if (interactive()) {
  ui <- fluidPage(
    shinyGovstyle::header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo="shinyGovstyle/images/moj_logo.png"),
    shinyGovstyle::gov_layout(size = "full",
      select_Input(
        inputId = "sorter",
        label = "Sort by",
        select_text = c("Recently published",
                        "Recently updated",
                        "Most views",
                        "Most comments"),
        select_value = c("published", "updated", "view", "comments")),
        tags$br()
    ),
    shinyGovstyle::footer(full = TRUE)
  )

  server <- function(input, output, session) {}
  shinyApp(ui = ui, server = server)
}
}
\keyword{select}
