% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R, R/source_tblist.R
\name{updating-data-statistics}
\alias{updating-data-statistics}
\alias{.update_data_stats}
\alias{.update_data_stats.default}
\alias{.update_data_stats.tblist}
\title{Render source data related statistics}
\usage{
.update_data_stats(source, ...)

\method{.update_data_stats}{default}(source, step_id, cohort, session, ...)

\method{.update_data_stats}{tblist}(source, step_id, cohort, session, ...)
}
\arguments{
\item{source}{Source object.}

\item{...}{Extra arguments passed to a specific method.}

\item{step_id}{Id if filtering step.}

\item{cohort}{Cohort object.}

\item{session}{Shiny session object.}
}
\value{
No return value, used for side effect which assigning Cohort data
    statistics to the `output` object.
}
\description{
The function should assign rendering that displays data source statistics to the valid output.
By default, the output is placed within \link{.render_filters} method.
}
\details{
When rendering the output, a good practice is to use cached data statistics available with
`cohort$get_cache(step_id)`.
This way, you omit running additional computations which results with performance improvement.
}
\examples{
if (interactive()) {
  library(magrittr)
  library(shiny)
  library(cohortBuilder)
  library(shinyCohortBuilder)

  ui <- fluidPage(
    sliderInput("step_two_max", "Max step two copies", min = 6, max = 12, value = 8),
    uiOutput("2-stats_books")
  )

  server <- function(input, output, session) {
    coh <- cohort(
      set_source(as.tblist(librarian)),
      step(
        filter(
          "range", id = "copies", dataset = "books",
          variable = "copies", range = c(5, 12)
        )
      ),
      step(
        filter(
          "range", id = "copies", dataset = "books",
          variable = "copies", range = c(6, 8)
        )
      )
    ) \%>\% run()
    coh$attributes$stats <- c("pre", "post")
    observeEvent(input$step_two_max, {
      coh$update_filter("copies", step_id = 2, range = c(6, input$step_two_max))
      run(coh, min_step_id = "2")
      .update_data_stats(coh$get_source(), step_id = "2", cohort = coh, session = session)
    })
  }

  shinyApp(ui, server)
}

}
\seealso{
\link{source-gui-layer}
}
