% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.R, R/source_tblist.R
\name{autofilter}
\alias{autofilter}
\alias{autofilter.default}
\alias{autofilter.tblist}
\title{Generate filters definition based on the Source data}
\usage{
autofilter(source, attach_as = c("step", "meta"), ...)

\method{autofilter}{default}(source, ...)

\method{autofilter}{tblist}(source, attach_as = c("step", "meta"), ...)
}
\arguments{
\item{source}{Source object.}

\item{attach_as}{Choose whether the filters should be attached as a new step,
or list of available filters (used in filtering panel when `new_step = "configure"`).
By default in \code{step}.}

\item{...}{Extra arguments passed to a specific method.}
}
\value{
Source object having step configuration attached.
}
\description{
The method should analyze source data structure, generate proper filters based on
the data (e.g. column types) and attach them to source.
}
\examples{
library(magrittr)
library(cohortBuilder)
library(shinyCohortBuilder)

iris_source <- set_source(tblist(iris = iris)) \%>\%
  autofilter()
iris_cohort <- cohort(iris_source)
sum_up(iris_cohort)

if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    cb_ui("mycoh")
  )

  server <- function(input, output, session) {
    cb_server("mycoh", cohort = iris_cohort)
  }

  shinyApp(ui, server)
}
}
\seealso{
\link{source-gui-layer}
}
