% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menu.R
\name{horizontal_menu}
\alias{horizontal_menu}
\title{Horizontal menu}
\usage{
horizontal_menu(menu_items, active_location = "", logo = NULL)
}
\arguments{
\item{menu_items}{list with list that can have fields: "name" (mandatory),
"link" and "icon"}

\item{active_location}{active location of the menu (should match
one from "link")}

\item{logo}{optional argument that displays logo on the left
of horizontal menu, can be character with image location, or shiny image object}
}
\value{
shiny div with horizontal menu
}
\description{
Renders UI with horizontal menu
}
\examples{
library(shiny.semantic)
menu_content <- list(
 list(name = "AA", link = "http://example.com", icon = "dog"),
 list(name = "BB", link = "#", icon="cat"),
 list(name = "CC")
)
if (interactive()){
  ui <- semanticPage(
   horizontal_menu(menu_content)
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}
}
