% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropdown.R
\name{dropdown_input}
\alias{dropdown_input}
\title{Create dropdown Semantic UI component}
\usage{
dropdown_input(
  input_id,
  choices,
  choices_value = choices,
  default_text = "Select",
  value = NULL,
  type = "selection fluid"
)
}
\arguments{
\item{input_id}{Input name. Reactive value is available under input[[input_id]].}

\item{choices}{All available options one can select from.}

\item{choices_value}{What reactive value should be used for corresponding
choice.}

\item{default_text}{Text to be visible on dropdown when nothing is selected.}

\item{value}{Pass value if you want to initialize selection for dropdown.}

\item{type}{Change depending what type of dropdown is wanted.}
}
\description{
This creates a default *dropdown_input* using Semantic UI styles with Shiny input.
Dropdown is already initialized and available under input[[input_id]].
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
library(shiny)
library(shiny.semantic)
ui <- semanticPage(
  title = "Dropdown example",
  dropdown_input("simple_dropdown", LETTERS, value = "A"),
  p("Selected letter:"),
  textOutput("dropdown")
)
server <- function(input, output) {
  output$dropdown <- renderText(input[["simple_dropdown"]])
}

shinyApp(ui = ui, server = server)
}

}
