% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/button.R
\name{counter_button}
\alias{counter_button}
\title{Counter Button}
\usage{
counter_button(
  input_id,
  label = "",
  icon = NULL,
  value = 0,
  color = "",
  size = "",
  big_mark = " "
)
}
\arguments{
\item{input_id}{The \code{input} slot that will be used to access the value.}

\item{label}{the content of the item to display}

\item{icon}{an optional \code{\link{icon}()} to appear on the button.}

\item{value}{initial rating value (integer)}

\item{color}{character with semantic color}

\item{size}{character with size of the button, eg. "medium", "big"}

\item{big_mark}{big numbers separator}
}
\value{
counter button object
}
\description{
Creates a counter button whose value increments by one each time it is pressed.
}
\examples{
if (interactive()) {
library(shiny)
library(shiny.semantic)
ui <-semanticPage(
     counter_button("counter", "My Counter Button",
                   icon = icon("world"),
                   size = "big", color = "purple")
 )
server <- function(input, output) {
 observeEvent(input$counter,{
   print(input$counter)
  })
 }
shinyApp(ui, server)
}
}
