% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{EditableText}
\alias{EditableText}
\alias{EditableText.shinyInput}
\title{Editable text}
\usage{
EditableText(...)

EditableText.shinyInput(inputId, ..., value = defaultValue)
}
\arguments{
\item{...}{Component props and children. See the official Blueprint docs for details.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{value}{Initial value.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Documentation: \url{https://blueprintjs.com/docs/#core/components/editable-text}
}
\examples{
library(shiny.blueprint)
library(shiny)

ui <- function(id) {
  ns <- NS(id)
  tagList(
    H2(EditableText(onChange = setInput(ns("header")))),
    EditableText.shinyInput(
      inputId = ns("body"),
      multiline = TRUE,
      minLines = 3, maxLines = 12
    ),
    textOutput(ns("headerValue")),
    textOutput(ns("bodyValue"))
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {
    output$headerValue <- renderText(paste("Header:", deparse(input$header)))
    output$bodyValue <- renderText(paste("Body:", deparse(input$body)))
  })
}

if (interactive()) shinyApp(ui("app"), function(input, output) server("app"))
}
