% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{benchmark}
\alias{benchmark}
\title{Execute performance tests for a list of commits}
\usage{
benchmark(
  commit_list,
  cypress_dir = NULL,
  shinytest2_dir = NULL,
  tests_pattern = NULL,
  app_dir = getwd(),
  port = 3333,
  use_renv = TRUE,
  renv_prompt = TRUE,
  n_rep = 1,
  debug = FALSE
)
}
\arguments{
\item{commit_list}{A list of commit hash codes, branches' names or anything
else you can use with git checkout \link{...}}

\item{cypress_dir}{The directory with tests recorded by Cypress.
It can also be a vector of the same size of commit_list}

\item{shinytest2_dir}{The directory with tests recorded by shinytest2
It can also be a vector of the same size of commit_list}

\item{tests_pattern}{Cypress/shinytest2 files pattern. E.g. 'performance'
It can also be a vector of the same size of commit_list. If it is NULL,
all the content in cypress_dir/shinytest2_dir will be used}

\item{app_dir}{The path to the application root}

\item{port}{Port to run the app}

\item{use_renv}{In case it is set as TRUE, package will try to apply
renv::restore() in all branches. Otherwise, the current loaded list of
packages will be used in all branches.}

\item{renv_prompt}{Prompt the user before taking any action?}

\item{n_rep}{Number of replications desired}

\item{debug}{Logical. TRUE to display all the system messages on runtime}
}
\value{
Return a \code{shiny_benchmark} object containing the \code{benchmark} call,
elapsed time and a \code{list} with the collected performance times
}
\description{
Execute performance tests for a list of commits
}
