% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{shiny_progress}
\alias{shiny_progress}
\title{Wrapper of shiny progress that can run without shiny}
\usage{
shiny_progress(
  title,
  max = 1,
  ...,
  quiet = FALSE,
  session = shiny::getDefaultReactiveDomain(),
  shiny_auto_close = FALSE,
  log = NULL,
  outputId = NULL
)
}
\arguments{
\item{title}{the title of the progress}

\item{max}{max steps of the procedure}

\item{...}{passed to initialization method of \code{\link[shiny]{Progress}}}

\item{quiet}{whether the progress needs to be quiet}

\item{session}{shiny session domain}

\item{shiny_auto_close}{whether to close the progress once function exits}

\item{log}{alternative log function}

\item{outputId}{the element id of \code{\link{progressOutput}}, or
\code{NULL} to use the default shiny progress}
}
\value{
a list of functions that controls the progress
}
\description{
Wrapper of shiny progress that can run without shiny
}
\examples{

{
  progress <- shiny_progress("Procedure A", max = 10)
  for(i in 1:10){
    progress$inc(sprintf("Step \%s", i))
    Sys.sleep(0.1)
  }
  progress$close()

}

if(interactive()){
  library(shiny)

  ui <- fluidPage(
    fluidRow(
      column(12, actionButton("click", "Click me"))
    )
  )

  server <- function(input, output, session) {
    observeEvent(input$click, {
      progress <- shiny_progress("Procedure B", max = 10,
                                 shiny_auto_close = TRUE)
      for(i in 1:10){
        progress$inc(sprintf("Step \%s", i))
        Sys.sleep(0.1)
      }
    })
  }

  shinyApp(ui, server)
}

}
