% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card-tool.R
\name{card_tool}
\alias{card_tool}
\title{Generates small icon widgets}
\usage{
card_tool(
  inputId = NULL,
  title = NULL,
  widget = c("maximize", "collapse", "remove", "flip", "refresh", "link", "custom"),
  icon,
  class = "",
  href = "#",
  target = "_blank",
  start_collapsed = FALSE,
  ...
)
}
\arguments{
\item{inputId}{the button id, only necessary when \code{widget}
is \code{"custom"}}

\item{title}{the tip message to show when the mouse cursor hovers
on the icon}

\item{widget}{the icon widget type; choices are \code{"maximize"},
\code{"collapse"}, \code{"remove"}, \code{"flip"},
\code{"refresh"}, \code{"link"}, and \code{"custom"}; see 'Details'}

\item{icon}{icon to use if you are unsatisfied with the default ones}

\item{class}{additional class for the tool icons}

\item{href, target}{used when \code{widget} is \code{"link"}, will
open an external website; default is open a new tab}

\item{start_collapsed}{used when \code{widget} is \code{"collapse"},
whether the card should start collapsed}

\item{...}{passed to the tag as attributes}
}
\value{
'HTML' tags to be included in \code{tools} parameter in
\code{\link{accordion}}, \code{\link{card}}, \code{\link{card2}},
\code{\link{card_tabset}}
}
\description{
The icons cane be displayed at header line within
\code{\link{accordion}}, \code{\link{card}}, \code{\link{card2}},
\code{\link{card_tabset}}. See their examples.
}
\details{
There are 7 \code{widget} types:
\describe{
\item{\code{"maximize"}}{allow the elements to maximize
themselves to full-screen}
\item{\code{"collapse"}}{allow the elements to collapse}
\item{\code{"remove"}}{remove a \code{\link{card}} or
\code{\link{card2}}}
\item{\code{"flip"}}{used together with \code{\link{flip_box}},
to allow card body to flip over}
\item{\code{"refresh"}}{refresh all shiny outputs}
\item{\code{"link"}}{open a hyper-link pointing to external
websites}
\item{\code{"custom"}}{turn the icon into a \code{actionButton}.
in this case, \code{inputId} must be specified.}
}
}
