% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print.naBlocks}
\alias{print.naBlocks}
\title{Print Missingness Pattern}
\usage{
\method{print}{naBlocks}(x, ...)
}
\arguments{
\item{x}{An \code{naBlocks} object.}

\item{...}{Additional parameters passed to \code{\link[base]{print}}.}
}
\value{
A named matrix representing the missingness pattern of the data.
}
\description{
Print the pattern of missingness in the supplied data, as a block matrix.
Observed data are represented by 1, missing values by 0.
}
\details{
The first row shows the column names. The leftmost column, without column
name, shows the number of rows per block and the rightmost column with name
\verb{#} shows the number of observed variables in the block.
}
\examples{
    x <- mvtnorm::rmvt(100, toeplitz(seq(1, 0.1, length.out = 3)), df = 5)
    y <- mice::ampute(x, mech='MCAR')$amp
    res <- classicShapeNA(y)
    print(res$naBlocks)
}
